/*
    server.c

    Arpaci-Dusseau, OSTEP v1.10, Chapter 48
    With modifications by Bridger Herman for CS208 W25
    and Tanya Amert for CS208 S25

    Example UDP Code (client.c, server.c)

    Compile with:

        gcc -Wall -Werror -o server server.c
*/

#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>

#include "common.h"

// Server: Sets up a socket to listen for connections on
// port PORT (see common.h).
int main(int argc, char *argv[])
{
    // Create socket
    int sockfd;
    if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
    {
        printf("Unable to create socket\n");
        return -1;
    }

    // Bind socket to port PORT on this machine
    struct sockaddr_in servaddr;
    bzero(&servaddr, sizeof(servaddr));
    servaddr.sin_family = AF_INET; // IPv4 addresses
    servaddr.sin_port = htons(PORT); // network byte order of port
    servaddr.sin_addr.s_addr = INADDR_ANY; // accept any connection
    if (bind(sockfd, (struct sockaddr *)&servaddr,
             sizeof(servaddr)) == -1)
    {
        close(sockfd);
        printf("Unable to bind socket\n");
        return -1;
    }

    // Keep the server running infinitely, and receive BUFFER_SIZE bytes at a time
    printf("Opened socket server port %d (fd %d)\n", PORT, sockfd);
    assert(sockfd > -1);
    while (1)
    {
        // Wait until we receive a message
        char message[BUFFER_SIZE];
        int read_bytes = recv(sockfd, message, BUFFER_SIZE, 0);

        // Print out the message received
        printf("Message (%d bytes) %s\n", read_bytes, message);
    }

    // Successful execution!
    return 0;
}